/**
 * @description Gestion des inputs file
 */
function inputfile() {
  const fileInputs = document.querySelectorAll('.custom-file-input');
  if (!fileInputs) {
    return;
  }

  /**
   * @description
   * - Affichage du nom du fichier afficher dans l'input file
   * - Suppression de la classe placeholder
   * - Ajout classe active
   */
  fileInputs.forEach((input) => {
    input.addEventListener('change', (e) => {
      e.target.nextElementSibling.innerText = e.target.files[0].name;
      e.target.nextElementSibling.classList.remove('custom-file-placeholder');
      e.target.parentElement.classList.add('active');
    });
  });
}

export default inputfile;
