<?php

declare(strict_types=1);

namespace Dedi\SyliusTheme\Templating\Helper;

use Dedi\SyliusTheme\Resolver\ProductVariantResolverInterface;
use Sylius\Bundle\CoreBundle\Templating\Helper\VariantResolverHelper as BaseVariantResolverHelper;
use Sylius\Component\Product\Model\ProductInterface;
use Sylius\Component\Product\Model\ProductVariantInterface;

final class VariantResolverHelper extends BaseVariantResolverHelper
{
    private readonly ProductVariantResolverInterface $productVariantResolver;

    public function __construct(
        ProductVariantResolverInterface $productVariantResolver,
    ) {
        parent::__construct($productVariantResolver);

        $this->productVariantResolver = $productVariantResolver;
    }

    public function resolveVariantWithCode(ProductInterface $product, string $code): ?ProductVariantInterface
    {
        return $this->productVariantResolver->getVariantWithCode($product, $code);
    }
}
