<?php

declare(strict_types=1);

namespace Dedi\SyliusTheme\Sales\Form\Extension;

use Dedi\SyliusTheme\Common\Form\Type\CheckboxWithLinkType;
use Sylius\Bundle\CoreBundle\Form\Type\Checkout\SelectPaymentType;
use Symfony\Component\Form\AbstractTypeExtension;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\IsTrue;

class SelectPaymentTypeExtension extends AbstractTypeExtension
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('acceptTermsOfSales', CheckboxWithLinkType::class, [
                'label' => 'app.ui.form.accept_tos',
                'mapped' => false,
                'constraints' => [
                    new IsTrue([
                        'message' => 'app.ui.you_must_accept_the_terms_of_sales',
                        'groups' => ['default', 'sylius'],
                    ]),
                ],
                'validation_groups' => ['default', 'sylius'],
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver
            ->setDefaults([
                'validation_groups' => ['default', 'sylius'],
            ])
        ;
    }

    public static function getExtendedTypes(): iterable
    {
        return [SelectPaymentType::class];
    }
}
