/**
 * @description
 * Import des libs externes
 */
import 'bootstrap-select'; // https://developer.snapappointments.com/bootstrap-select/
import 'bootstrap-select/js/i18n/defaults-fr_FR';
import 'bootstrap-input-spinner/src/bootstrap-input-spinner'; // https://shaack.com/projekte/bootstrap-input-spinner/
import 'simplebar'; // https://github.com/Grsmto/simplebar/tree/master/packages/simplebar

/**
 * @description
 * Import des libs Dedi
 */
import carousel from './lib/carousels';
import customCollapse from './lib/custom-collapse';
import dediMenu from './lib/dediMenu';
import form from './lib/form';
import inputfile from './lib/inputfile';
import search from './lib/search';
import selection from './lib/selection';
import showHide from './lib/showHide';
import smoothScroll from './lib/smoothScroll';

document.addEventListener('DOMContentLoaded', () => {
  /**
   * @description Chargement des modules JS Dedi
   */
  carousel();
  customCollapse();
  dediMenu();
  form();
  inputfile();
  search();
  selection();
  showHide();
  smoothScroll();

  /**
   * @description Tooltip
   */
  $('[data-toggle="tooltip"]').tooltip({
    html: true,
  });
});
