<?php

declare(strict_types=1);

namespace Dedi\SyliusTheme\Common\Form\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;

/**
 * This type allows to have link in the label of a checkbox.
 *
 * For instance, a label with the following translations:
 * 'Something: #LINK("Dedi","https://www.dedi-agency.com/")# and #LINK("Google","https://google.com/")#'
 * Will render the following label:
 * 'Something: <a href="https://www.dedi-agency.com/">Dedi</a> and <a href="https://google.com/">Google</a>'
 */
class CheckboxWithLinkType extends AbstractType
{
    public function getParent()
    {
        return CheckboxType::class;
    }

    public function getBlockPrefix()
    {
        return 'checkbox_with_link';
    }
}
