import hljs from 'highlight.js/lib/core';
import xml from 'highlight.js/lib/languages/xml';
import twig from 'highlight.js/lib/languages/twig';
import 'highlight.js/styles/default.css';

import colors from './colors';
import menuMobile from './menuMobile';
import showCode from './showCode';

require('../../scss/pages/design-system.scss');

document.addEventListener('DOMContentLoaded',
  () => {
    hljs.registerLanguage('xml', xml);
    hljs.registerLanguage('twig', twig);
    hljs.highlightAll();

    colors();
    menuMobile();
    showCode();
  });
