<?php

declare(strict_types=1);

namespace Dedi\SyliusTheme\Twig;

use Dedi\SyliusTheme\Templating\Helper\VariantResolverHelper;
use Twig\Extension\AbstractExtension;
use Twig\TwigFilter;

final class VariantResolverExtension extends AbstractExtension
{
    private readonly VariantResolverHelper $helper;

    public function __construct(VariantResolverHelper $helper)
    {
        $this->helper = $helper;
    }

    public function getFilters(): array
    {
        return [
            new TwigFilter('dedi_theme_resolve_variant_with_code', [$this->helper, 'resolveVariantWithCode']),
        ];
    }
}
