<?php

declare(strict_types=1);

namespace Dedi\SyliusTheme\Common\Twig\Extension;

use Twig\Extension\AbstractExtension;
use Twig\TwigFunction;

class UnserializeAppliedPromotionsFromSearchResultExtension extends AbstractExtension
{
    public function getFunctions()
    {
        return [
            new TwigFunction('unserialize_applied_promotions_from_search_result', [$this, 'unserializeAppliedPromotionsFromSearchResult']),
        ];
    }

    public function unserializeAppliedPromotionsFromSearchResult(array $data): array
    {
        return array_map(static fn ($line) => unserialize($line), $data);
    }
}
