/**
 * @description Gestion des formulaires
 * - Bootstrap select
 * - Champs actifs
 */

/**
 * @description Activation des input si une valeur est renseignée
 */
function inputActive(el) {
  if (el.value) {
    el.classList.add('active');
  } else {
    el.classList.remove('active');
  }
}

export default () => {
  /**
     * @description Activation des input text et textarea lorsqu'ils sont remplis
     */
  const els = document.querySelectorAll('.form-control');
  Array.from(els)
    .forEach((el) => {
      inputActive(el);

      el.addEventListener('blur', () => {
        inputActive(el);
      });
    });

  /**
     * @description Boostrap Select
     * Hack boostrap 4
     * Activation du champ lorsqu'une valeur est sélectionnée
     */
  $.fn.selectpicker.Constructor.BootstrapVersion = '4';
  $('.selectpicker').on('changed.bs.select', (e, clickedIndex, isSelected) => {
    const dropDown = e.target.nextSibling;
    if (isSelected && e.target.value) {
      dropDown.classList.add('active');
    } else {
      dropDown.classList.remove('active');
    }
  });

  /**
     * @description Initialisation des champs number
     */
  if ($('.input-number')) {
    $('.input-number').inputSpinner({
      groupClass: 'custom-input-number',
      buttonsWidth: 0,
      decrementButton: '',
      incrementButton: '',
    });
  }

  /**
   * @description Initialisation des selectpicket
   */
  $('.selectpicker').selectpicker({
    style: '',
    styleBase: '',
  });

  /**
   * @description Loader lors de l'ajout au panier
   * Un petit loader apparaît sur le bouton d'ajout au panier lors du post du formulaire jusqu'au rechargement de la page
   * Le type du bouton passe de submit à button pour éviter de poster le formulaire plusieurs fois
   */
  const formsAddToCart = document.querySelectorAll('#sylius-product-adding-to-cart');
  Array.from(formsAddToCart)
    .forEach((form) => {
      form.addEventListener('submit', () => {
        const button = form.querySelector('.btn-add-cart');
        button.classList.add('load');
        button.setAttribute('type', 'button');
      });
    });
};
