<?php

declare(strict_types=1);

use Rector\Config\RectorConfig;
use Rector\Core\Configuration\Option;
use Rector\Php74\Rector\Closure\ClosureToArrowFunctionRector;
use Rector\Php74\Rector\Property\TypedPropertyRector;
use Rector\Set\ValueObject\SetList;

return static function (RectorConfig $containerConfigurator): void {
    // get parameters
    $containerConfigurator->paths([
            __DIR__ . '/src',
        ]
    );

    // Define what rule sets will be applied
    $containerConfigurator->import(SetList::PHP_81);

    $containerConfigurator->importNames();
    $containerConfigurator->importShortClasses();

    $services = $containerConfigurator->services();
    $services->set(TypedPropertyRector::class);
    $services->set(ClosureToArrowFunctionRector::class);
};