<?php

declare(strict_types=1);

namespace Dedi\SyliusTheme\Utils\Icon;

use Symfony\Component\Config\FileLocator;
use Symfony\Component\Finder\Finder;

class TwigIconList implements IconListInterface
{
    private array $icons = [];

    public function __construct(string $directoryPath)
    {
        $fileLocator = new FileLocator(__DIR__ . '/../../..');

        foreach (Finder::create()->in($fileLocator->locate($directoryPath))->files() as $file) {
            $file = str_replace('.html', '', $file->getFilenameWithoutExtension());
            $this->icons[ucfirst($file)] = $file;
        }
    }

    public function getListName(): string
    {
        return 'Icons';
    }

    public function getList(): array
    {
        return $this->icons;
    }
}
