/**
 * @description Adouci l'effet de scroll sur une ancre
 * @param {HTMLelement} link - Element lien qu'il contient l'ancre qu'il faut "adoucir" (ID ou Class)
 * @param {Number} [offsetTop=250] - Marge au dessus de l'ancre (50 par défaut)
 * @param {Object} [options={ behavior: 'smooth' } - Options pour la fonction scrollIntoView
 */
function smoothScroll(link, offsetTop = 50, options = { behavior: 'smooth' }) {
  const anchorParent = document.querySelector(link.getAttribute('href'));

  // Création d'une ancre invisible pour prendre en compte la marge offsetTop
  const anchor = document.createElement('div');
  anchor.setAttribute('id', `${anchorParent.getAttribute('id')}-anchor`);
  anchorParent.prepend(anchor);
  anchor.style.position = 'absolute';
  anchor.style.top = `-${offsetTop}px`;

  anchorParent.style.position = 'relative';

  // Scroll
  anchor.scrollIntoView(options);

  // Suppression de l'ancre invisible
  anchor.remove();
  anchorParent.style.position = null;
}

export default () => {
  const {
    smoothScrollEnabled = true,
    smoothScrollSelector = '.smoothscroll',
    smoothScrollOffsetTop,
    smoothScrollOptions,
  } = window.DEDI_THEME;

  const links = document.querySelectorAll(smoothScrollSelector);
  if (links && smoothScrollEnabled) {
    Array.from(links)
      .forEach((link) => {
        link.addEventListener('click', (e) => {
          e.preventDefault();
          smoothScroll(link, smoothScrollOffsetTop, smoothScrollOptions);
        });
      });
  }
};
