/**
 * @description Recherche header
 */

const header = document.querySelector('.header-container');
const search = document.querySelector('.header-search-wrapper');

function searchPosition() {
  if (search.classList.contains('active') && window.matchMedia('(max-width: 991px)').matches) {
    search.style.paddingTop = `${header.clientHeight}px`;
  } else {
    search.style.paddingTop = '';
  }
}

export default () => {
  /**
   * @description Affichage de la barre de recherche lorsqu'on clique sur l'icone
   */
  if (search) {
    const el = document.querySelector('.header-link-search');

    if (el) {
      el.addEventListener('click', (e) => {
        e.preventDefault();
        search.classList.toggle('active');
        searchPosition();
      });
    }

    window.addEventListener('resize', () => {
      searchPosition();
    });
  }
};
