<?php

declare(strict_types=1);

namespace Dedi\SyliusTheme\Twig;

use Sylius\Bundle\MoneyBundle\Templating\Helper\FormatMoneyHelperInterface;
use Twig\Extension\AbstractExtension;
use Twig\TwigFilter;

class FormatMoneyExtension extends AbstractExtension
{
    private FormatMoneyHelperInterface $helper;

    public function __construct(FormatMoneyHelperInterface $helper)
    {
        $this->helper = $helper;
    }

    /**
     * @inheritdoc
     */
    public function getFilters(): array
    {
        return [
            new TwigFilter('sylius_format_money', [$this->helper, 'formatAmount'], ['is_safe' => ['html']]),
        ];
    }
}
