<?php

declare(strict_types=1);

namespace Dedi\SyliusTheme\Utils\Icon;

class IconList implements IconListInterface
{
    /** @var IconListInterface[] */
    private array $listes;

    public function __construct(iterable $listes)
    {
        $this->listes = iterator_to_array($listes);
    }

    public function getListName(): string
    {
        return '';
    }

    public function getList(): array
    {
        return array_reduce($this->listes, static function (array $list, IconListInterface $iconList) {
            $list[$iconList->getListName()] = $iconList->getList();

            return $list;
        }, []);
    }
}
