const path = require('path');
const Encore = require('@symfony/webpack-encore');

const syliusBundles = path.resolve(__dirname, '../../vendor/sylius/sylius/src/Sylius/Bundle/');
const uiBundleScripts = path.resolve(syliusBundles, 'UiBundle/Resources/private/js/');
const uiBundleResources = path.resolve(syliusBundles, 'UiBundle/Resources/private/');

// Shop config
Encore
    .setOutputPath('public/assets/shop/')
    .setPublicPath('/assets/shop')
    .addEntry('shop', path.resolve(__dirname, '../../vendor/sylius/sylius/src/Sylius/Bundle/ShopBundle/Resources/private/entry.js'))
    .configureFilenames({
        js: 'js/app.js',
        css: 'css/style.css',
        images: 'img/[name].[ext]',
        fonts: 'fonts/[name].[ext]',
    })
    .addAliases({
        'sylius/ui': uiBundleScripts,
        'sylius/ui-resources': uiBundleResources,
        'sylius/bundle': syliusBundles,
    })
    .disableSingleRuntimeChunk()
    .cleanupOutputBeforeBuild()
    .enableSourceMaps(!Encore.isProduction())
    .enableVersioning(Encore.isProduction())
    .enableSassLoader();

const shopConfig = Encore.getWebpackConfig();
shopConfig.name = 'shop';

Encore.reset();

// Admin config
Encore
    .setOutputPath('public/assets/admin/')
    .setPublicPath('/assets/admin')
    .addEntry('admin', path.resolve(__dirname, '../../vendor/sylius/sylius/src/Sylius/Bundle/AdminBundle/Resources/private/entry.js'))
    .configureFilenames({
        js: 'js/app.js',
        css: 'css/style.css',
        images: 'img/[name].[ext]',
        fonts: 'fonts/[name].[ext]',
    })
    .addAliases({
        'sylius/ui': uiBundleScripts,
        'sylius/ui-resources': uiBundleResources,
        'sylius/bundle': syliusBundles,
    })
    .addExternals({
        window: 'window',
        document: 'document',
    })
    .disableSingleRuntimeChunk()
    .cleanupOutputBeforeBuild()
    .enableSourceMaps(!Encore.isProduction())
    .enableVersioning(Encore.isProduction())
    .enableSassLoader();

const adminConfig = Encore.getWebpackConfig();
adminConfig.name = 'admin';

Encore.reset();

const dediThemeConfig = require('./../../webpack.config')(Encore);

module.exports = [shopConfig, adminConfig, dediThemeConfig];
