/**
 * @description Gestion des carousels
 */

/**
 * @description slider par défaut
 *
 * @param {String} [selector=.default-slider]
 * @param {Object|null} [options=null]
 */
function sliderDefault(selector = '.default-slider', options = null) {
  options = options || {
    slidesToShow: 1,
    slidesToScroll: 1,
    dots: true,
    arrows: true,
    prevArrow: '<button type="button" class="slick-prev slick-arrow"></button>',
    nextArrow: '<button type="button" class="slick-next slick-arrow"></button>',
  };

  if (document.querySelector(selector)) {
    $(selector).slick(options);
  }
}

/**
 * @description Carousel image produit avec carousel sur les thumbnails
 * Suppression des lightbox sur les éléments clonés
 *
 * @param {String} [productImageSliderSelector=.product-show-images-slider] - Selecteur pour les images produit principaux
 * @param {String} [thumbnailImageSliderSelector=.default-slider] - Selecteur pour les miniatures produit
 * @param {Object|null} [productImageSliderOptions=null] - Options pour le carrousel des images produit principaux
 * @param {Object|null} [thumbnailImageSliderOptions=null] - Options pour le carrousel des miniatures produit
 */
function sliderProduct(
  productImageSliderSelector = '.product-show-images-slider',
  thumbnailImageSliderSelector = '.product-show-images-thumbnail',
  productImageSliderOptions = null,
  thumbnailImageSliderOptions = null,
) {
  productImageSliderOptions = productImageSliderOptions || {
    slidesToShow: 1,
    slidesToScroll: 1,
    arrows: false,
    dots: true,
    mobileFirst: true,
    responsive: [
      {
        breakpoint: 767,
        settings: {
          dots: false,
          asNavFor: '.product-show-images-thumbnail',
        },
      },
    ],
  };

  thumbnailImageSliderOptions = thumbnailImageSliderOptions || {
    slidesToShow: 4,
    slidesToScroll: 1,
    asNavFor: '.product-show-images-slider',
    dots: false,
    arrows: false,
    focusOnSelect: true,
    mobileFirst: true,
    responsive: [
      {
        breakpoint: 1199,
        settings: {
          slidesToShow: 5,
        },
      },
    ],
  };

  if (document.querySelector(productImageSliderSelector)) {
    $(productImageSliderSelector).on('init', () => {
      const clonedItems = document.querySelectorAll(`${productImageSliderSelector} .slick-cloned`);
      Array.from(clonedItems)
        .forEach((clonedItem) => {
          // eslint-disable-next-line no-param-reassign
          clonedItem.innerHTML = clonedItem.querySelector('a').innerHTML;
        });
    })
      .slick(productImageSliderOptions);

    // Remove active class from all thumbnail slides
    $(thumbnailImageSliderSelector).find('.slick-dot').removeClass('slick-active');

    // Set active class to first thumbnail slides
    $(thumbnailImageSliderSelector).find('.slick-dot').eq(0).addClass('slick-active');

    // On before slide change match active thumbnail to current slide
    $(productImageSliderSelector).on('beforeChange', (event, slick, currentSlide, nextSlide) => {
      $(thumbnailImageSliderSelector).find('.slick-dot').removeClass('slick-active');
      $(thumbnailImageSliderSelector).find('.slick-slide:not(.slick-cloned)').eq(nextSlide).find('.slick-dot')
        .addClass('slick-active');
    });
  }

  if (document.querySelector(thumbnailImageSliderSelector)) {
    $(thumbnailImageSliderSelector).slick(thumbnailImageSliderOptions);
  }
}

/**
 * @description cross-selling
 * @param {String} [crossSellingSliderSelector=.cross-slider] - Selecteur pour les cross-selling
 * @param {String} [crossSellingSliderNav=.cross-slider-dots] - Selecteur pour les dotss du slider
 * @param {Object|null} [crossSellingSliderOptions=null] - Options pour le carrousel des cross-selling
 */
function sliderCrossSelling(
  crossSellingSliderSelector = '.cross-slider',
  crossSellingSliderNav = '.cross-slider-dots',
  crossSellingSliderOptions = null,
) {
  crossSellingSliderOptions = crossSellingSliderOptions || {
    slidesToShow: 2,
    slidesToScroll: 2,
    dots: true,
    arrows: false,
    infinite: false,
    mobileFirst: true,

    responsive: [
      {
        breakpoint: 767,
        settings: {
          slidesToShow: 3,
          slidesToScroll: 3,
        },
      },
      {
        breakpoint: 991,
        settings: {
          slidesToShow: 4,
          slidesToScroll: 4,
        },
      },
      {
        breakpoint: 1299,
        settings: {
          slidesToShow: 4,
          slidesToScroll: 4,
          arrows: true,
          prevArrow: '<button type="button" class="slick-prev slick-arrow"></button>',
          nextArrow: '<button type="button" class="slick-next slick-arrow"></button>',
        },
      },
    ],
  };

  if (document.querySelector(crossSellingSliderSelector)) {
    const sliders = document.querySelectorAll(crossSellingSliderSelector);
    sliders.forEach((slider) => {
      const sliderNav = slider.parentElement.querySelector(crossSellingSliderNav);
      crossSellingSliderOptions = {
        ...crossSellingSliderOptions,
        ...{
          appendDots: sliderNav,
        }
      };
      $(slider).slick(crossSellingSliderOptions);
    });
  }
}

export default () => {
  const {
    defaultCarouselEnabled = true,
    defaultCarouselSelector,
    defaultCarouselOptions,

    productCarouselEnabled = true,
    productCarouselMainSelector,
    productCarouselThumbnailSelector,
    productCarouselMainOptions,
    productCarouselThumbnailOptions,

    crossSellingSliderEnabled = true,
    crossSellingSliderSelector,
    crossSellingSliderNav,
    crossSellingSliderOptions,
  } = window.DEDI_THEME;

  if (defaultCarouselEnabled) {
    sliderDefault(defaultCarouselSelector, defaultCarouselOptions);
  }

  if (productCarouselEnabled) {
    sliderProduct(
      productCarouselMainSelector,
      productCarouselThumbnailSelector,
      productCarouselMainOptions,
      productCarouselThumbnailOptions,
    );
  }

  if (crossSellingSliderEnabled) {
    sliderCrossSelling(
      crossSellingSliderSelector,
      crossSellingSliderNav,
      crossSellingSliderOptions,
    );
  }
};
