/*
 * This file is part of the Sylius package.
 *
 * (c) Paweł Jędrzejewski
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/* eslint-env browser */

const handleProductOptionsChange = function handleProductOptionsChange({ syliusDisableProductOptionsChangeFormToggle }) {
  document.querySelectorAll('[name*="sylius_add_to_cart[cartItem][variant]"]').forEach((item) => {
    item.addEventListener('change', () => {
      let selector = '';

      document.querySelectorAll('#sylius-product-adding-to-cart select[data-option]').forEach((element) => {
        const select = element;
        const option = select[select.selectedIndex].value;
        selector += `[data-${select.getAttribute('data-option')}="${option}"]`;
      });

      document.querySelectorAll('#sylius-product-adding-to-cart [data-option] input[type="radio"]:checked').forEach((element) => {
        const { option } = element.closest('[data-option]').dataset;
        selector += `[data-${option}="${element.value}"]`;
      });

      const price = document.querySelector('#sylius-variants-pricing').querySelector(selector);
      const addToCartButton = document.querySelector('form[name=sylius_add_to_cart] button[type=submit]');
      const priceContainer = document.querySelector('.product-show-price');

      if (price) {
        priceContainer.innerHTML = price.innerHTML;
        if (!syliusDisableProductOptionsChangeFormToggle) {
          addToCartButton.removeAttribute('disabled');
        }
      } else {
        priceContainer.innerHTML = document.querySelector('#sylius-variants-pricing').getAttribute('data-unavailable-text');
        if (!syliusDisableProductOptionsChangeFormToggle) {
          addToCartButton.setAttribute('disabled', 'disabled');
        }
      }
    });
  });
};

const handleProductVariantsChange = function handleProductVariantsChange() {
  document.querySelectorAll('[name="sylius_add_to_cart[cartItem][variant]"]').forEach((item) => {
    item.addEventListener('change', () => {
      const selector = `[data-variant-code="${item.value}"]`;
      const price = document.querySelector('#sylius-variants-pricing').querySelector(selector);

      if (price !== undefined) {
        document.querySelector('.product-show-price').innerHTML = price.innerHTML;
        document.querySelector('button[type=submit]').removeAttribute('disabled');
      } else {
        document.querySelector('.product-show-price').innerHTML = document.querySelector('#sylius-variants-pricing').getAttribute('data-unavailable-text');
        document.querySelector('button[type=submit]').setAttribute('disabled', 'disabled');
      }
    });
  });
};

const SyliusVariantsPrices = ({ syliusDisableProductOptionsChangeFormToggle }) => {
  const syliusVariantsPricing = document.getElementById('sylius-variants-pricing') || null;
  const syliusProductVariants = document.getElementById('sylius-product-variants') || null;

  if (syliusVariantsPricing && !syliusProductVariants) {
    handleProductOptionsChange({ syliusDisableProductOptionsChangeFormToggle });
  } else if (syliusProductVariants) {
    handleProductVariantsChange();
  }
};

export default SyliusVariantsPrices;
