# Sylius Dedi theme

Thème par défaut de Dedi pour Sylius

## Installation

Ajouter le dépôt dans `composer.json`.

```json
{
  ...
    "repositories": [
        {
            "type": "vcs",
            "url": "git@gitlab.com:dedi-agency/sylius-theme.git"
        }
    ],
  ...,
}
```

Puis ajouter la dépendance.

```shell script
$ composer require dedi/theme:@dev --prefer-source
```

## Configuration

Importer la configuration webpack du thème sur le fichier principale du projet.

```javascript
// ./webpack.config.js

const Encore = require('@symfony/webpack-encore');

// ...

Encore.reset();

/**
 * Options disponibles (voir plus bas pour plus d'infos) :
 * aliases: Object
 * sassFilesToOverride: Object
 */
const options = { aliases: {}, sassFilesToOverride: {} };

const dediTheme = require('./vendor/dedi/theme/webpack.config')(Encore, options);
module.exports = [..., dediTheme];
```

Attention `dedi/theme` import une instance de jQuery, Popper.js, Lightbox et Bootstrap.js disponible dans l'objet `DEDI_THEME`, exemple :

```javascript
// ...

const { $, popper, lightbox, bootstrap } = DEDI_THEME;

$('.selectpicker').selectpicker();

// ...
```

Puis configurer en ajoutant dans `config/packages/assets.yaml` et `config/packages/webpack_encore.yaml`.

```yaml
# ./config/packages/assets.yaml

framework:
    assets:
        packages:
            ...
            dedi:
                json_manifest_path: '%kernel.project_dir%/public/build/dedi/manifest.json'
```

```yaml
# ./config/packages/webpack_encore.yaml

webpack_encore:
    output_path: ...
    builds:
        ...
        dedi: '%kernel.project_dir%/public/build/dedi'
```

Ajouter le thème dans sylius en éditant la configuration `config/_sylius.yaml`.

```yaml
# ./config/_sylius.yaml

sylius_theme:
    sources:
        filesystem:
            directories:
                - "%kernel.project_dir%/themes"
                - "%kernel.project_dir%/vendor/dedi/src/Resources/views/theme"
```

### Surcharger les fichiers SCSS

Tous les fichiers `.scss` peuvent être surchargé en important un object `sassFilesToOverride` clé / valeur avec :
- Clé : le fichier à surcharger
- Valeur : le chemin vers le fichier

Exemple : 

```javascript
// ./webpack.config.js

const Encore = require('@symfony/webpack-encore');

// ...

Encore.reset();

const options = { 
  aliases: {},
  sassFilesToOverride: {
    'atoms/_fonts.scss': path.resolve(__dirname, 'assets/demo/scss/atoms/_fonts.scss'), 
    'modules/_alerts.scss': path.resolve(__dirname, 'assets/demo/scss/molecules/_alerts.scss'),
  }
};

const dediTheme = require('./vendor/dedi/theme/webpack.config')(Encore, options);
module.exports = [..., dediTheme];
```

### Ajouter des alias utilisables dans les surcharges

Pour ajouter des alias permettant de faire un lien avec des fichiers statics dans la surcharge des fichiers SCSS, fournir un object `aliases` clé / valeur avec :
- Clé : Le nom de l'alias
- Valeur : Le chemin vers le dossier

Exemple :


```javascript
// ./webpack.config.js

const Encore = require('@symfony/webpack-encore');

// ...

Encore.reset();

const options = { 
  aliases: {
      'app-fonts': path.resolve(__dirname, 'assets/demo/fonts'),
  },
  sassFilesToOverride: {
      'atoms/_fonts.scss': path.resolve(__dirname, 'assets/demo/scss/atoms/_fonts.scss'),
  }
};

const dediTheme = require('./vendor/dedi/theme/webpack.config')(Encore, options);
module.exports = [..., dediTheme];
```

Puis dans `assets/demo/_fonts.scss` :

```scss

// Rubik
@font-face {
    font-family: $font-family-sans-serif;
    font-style: normal;
    font-weight: 300;
    src: url('~app-fonts/Rubik/rubik-light-webfont.woff2') format('woff2');
}
```

### Configuration options JS

Le plugin DediSyliusTheme peut être configuré via l'objet global `DEDI_THEME`, exemple :

```javascript
window.DEDI_THEME = {
    defaultCarouselEnabled = true,
    defaultCarouselSelector = '.slider',
    defaultCarouselOptions = {
      allow: true,
      ...
    },
};

```

Liste de toutes les options possibles :

La valeur par défaut `hérité` signifie que si l'option n'est pas renseignée, alors le plugin DediSyliusTheme applique une valeur par défaut spécifique.

| Nom                               | Type          | Defaut       | Description                               |
|:---------------------------------:|:-------------:|:------------:|:------------------------------------------|
| defaultCarouselEnabled            | Boolean       | true         | Active ou non le slider par défaut        |
| defaultCarouselSelector           | String        | hérité       | Défini le selecteur CSS pour le slider par défaut |
| defaultCarouselOptions            | Object        | hérité       | Défini les options passées à $(selector).slick(options) |
| productCarouselEnabled            | Boolean       | true         | Active ou non le slider de l'image produit |
| productCarouselMainSelector       | String        | hérité       | Défini le selecteur CSS pour le slider des images du produit |
| productCarouselThumbnailSelector  | String        | hérité       | Défini le selecteur CSS pour le slider des vignettes d'images produit |
| productCarouselMainOptions        | Object        | hérité       | Défini les options passées à $(selector).slick(options) pour le slider des images produits |
| productCarouselThumbnailOptions   | Object        | hérité       | Défini les options passées à $(selector).slick(options) pour le slider des vignettes des images produits |
| smoothScrollEnabled               | Boolean       | true         | Active ou non le scroll                     |
| smoothScrollSelector              | String        | hérité       | Défini le selecteur CSS                     |
| smoothScrollOffsetTop             | Number        | hérité       | Défini le offsetTop du scroll               |
| smoothScrollOptions               | Object        | hérité       | Défini l'object d'options scrollIntoView    |
| syliusProvinceEnabled             | Boolean       | true         | Active ou non la recherche de province Ajax |
| syliusProvinceBeforeAjaxCallback  | Function      | hérité       | Défini une fonction de rappel avant l'appel Ajax |
| syliusProvinceAfterAjaxCallback   | Function(response) | hérité       | Défini une fonction de rappel apres l'appel Ajax |
| syliusConfirmationEnabled         | Boolean       | true         | Active ou non les modals de confirmation    |
| syliusConfirmationSelector        | String        | hérité       | Défini le selecteur CSS                     |
| syliusConfirmationCallback        | Function      | hérité       | Définir la function de rappel après validation de la confirmation |

## Développement

Cloner le dépôt :

```bash
$ git clone git@gitlab.com:dedi-agency/sylius-theme.git dedi-theme
```

## Quickstart Installation

Pour faire fonctionner sans projet Sylius à coté :

```bash
$ make start
$ make db-create
$ make db-update
$ make fixtures
$ make build
```

Sinon :

Modifier composer.json du projet Sylius pour ajouter le repository local :

```json
{
  ...
    "repositories": [
        {
            "type": "path",
            "url": "/path/to/dedi-theme",
            "options": {
                "symlink": true
            }
        }
    ],
  ...,
}
```

Enfin créer le lien symbolique avec composer.

```
$ composer require dedi/theme:dev-master
```

Une autre solution est de clone le projet dans votre project Sylius.

Puis modifiez le composer.json du projet Sylius pour ajouter le repository local :

```json
{
  ...
    "repositories": [
        {
            "type": "vcs",
            "url": "https://gitlab.com/dedi-agency/interne/sylius/dedi-theme.git"
        },
    ],
  ...,
}
```

Puis faire

```
$ composer require dedi/theme:dev-master --prefer-source
```

## Ajouter une liste d'icônes pour le bloc UiElement "Icône et texte"

Créer une classe implémentant `Dedi\SyliusTheme\Utils\Icon\IconListInterface`.

Déclarer le service avec le tag `dedi_sylius_theme.icon_list`.

## Test

Test de code style.

```shell script
$ npm run test:cs
```

## Intégration

Modifier les fichiers scss/js dans le dossier dedi-theme puis copier les modifications dans les vendors du projet sylius
```bash
$ cp -R ~/PhpstormProjects/dedi-theme/* ~/PhpstormProjects/sylius/vendor/dedi/sylius-theme
```

Ou alors il est aussi possible d'utiliser rsync

```bash
$ rsync -aHAXxv --numeric-ids --copy-links ../dedi-theme/* vendor/dedi/sylius-theme
```
