<?php

declare(strict_types=1);

namespace Dedi\SyliusTheme\Utils\Icon;

use Symfony\Component\Config\FileLocator;
use Symfony\Component\Yaml\Yaml;

class FontawesomeIconList implements IconListInterface
{
    private array $icons = [];

    public function __construct(string $metadataFilepath)
    {
        $fileLocator = new FileLocator(__DIR__ . '/../../..');
        $metadata = Yaml::parseFile($fileLocator->locate($metadataFilepath));

        foreach ($metadata as $key => $value) {
            $this->icons[ucfirst($value['label'])] = $key;
        }
    }

    public function getListName(): string
    {
        return 'Fontawesome icons';
    }

    public function getList(): array
    {
        return $this->icons;
    }
}
