<?php

declare(strict_types=1);

namespace Dedi\SyliusTheme\Event;

use Sylius\Bundle\ResourceBundle\Event\ResourceControllerEvent;
use Sylius\Component\Channel\Context\RequestBased\RequestResolverInterface;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\Routing\RouterInterface;

class PostRegisterRedirectToCartListener
{
    private RouterInterface $router;

    private RequestStack $requestStack;

    public function __construct(RequestStack $requestStack)
    {
        $this->requestStack = $requestStack;
    }

    public function __invoke(ResourceControllerEvent $event)
    {
        $redirectTo = $this->requestStack->getMasterRequest()->get('redirect');

        if ($redirectTo) {
            $event->setResponse(new RedirectResponse($redirectTo));
        }
    }
}
