<?php

declare(strict_types=1);

namespace Dedi\SyliusTheme\Specification;

use Symfony\Component\HttpFoundation\Request;

class IsRequestFrontOfficeSpecification
{
    public const ADMIN_PATTERN = '/^\/admin\//';

    public function __invoke(
        ?Request $request
    ): bool {
        if (!$request) {
            return false;
        }

        return preg_match(self::ADMIN_PATTERN, $request->getPathInfo()) === 0;
    }
}
