const path = require('path');
const Encore = require('@symfony/webpack-encore');

const syliusBundles = path.resolve(__dirname, '../../vendor/sylius/sylius/src/Sylius/Bundle/');
const uiBundleScripts = path.resolve(syliusBundles, 'UiBundle/Resources/private/js/');
const uiBundleResources = path.resolve(syliusBundles, 'UiBundle/Resources/private/');

// Shop config
Encore
    .setOutputPath('public/build/shop/')
    .setPublicPath('/build/shop')
    .addEntry('shop-entry', './assets/shop/entry.js')
    .addAliases({
        'sylius/ui': uiBundleScripts,
        'sylius/ui-resources': uiBundleResources,
        'sylius/bundle': syliusBundles,
    })
    .addExternals({
        window: 'window',
        document: 'document',
    })
    .disableSingleRuntimeChunk()
    .cleanupOutputBeforeBuild()
    .enableSourceMaps(!Encore.isProduction())
    .enableVersioning(Encore.isProduction())
    .enableSassLoader();

const shopConfig = Encore.getWebpackConfig();
shopConfig.name = 'shop';

Encore.reset();

// Admin config
Encore
    .setOutputPath('public/build/admin/')
    .setPublicPath('/build/admin')
    .addEntry('admin-entry', './assets/admin/entry.js')
    .addAliases({
        'sylius/ui': uiBundleScripts,
        'sylius/ui-resources': uiBundleResources,
        'sylius/bundle': syliusBundles,
    })
    .addExternals({
        window: 'window',
        document: 'document',
    })
    .disableSingleRuntimeChunk()
    .cleanupOutputBeforeBuild()
    .enableSourceMaps(!Encore.isProduction())
    .enableVersioning(Encore.isProduction())
    .enableSassLoader();

const adminConfig = Encore.getWebpackConfig();
adminConfig.name = 'admin';

const dediThemeConfig = require('./../../webpack.config')(Encore);

Encore.reset();

Encore
    .setOutputPath('public/assets/demo')
    .setPublicPath('/assets/demo')
    .addEntry('app', `${__dirname}/assets/demo`)
    .disableSingleRuntimeChunk()
    .cleanupOutputBeforeBuild()
    .enableSassLoader()
    .enableSourceMaps(!Encore.isProduction())
    .enableVersioning(Encore.isProduction());

const demoConfig = Encore.getWebpackConfig();
demoConfig.name = 'dedi';

module.exports = [shopConfig, adminConfig, dediThemeConfig];
