/**
 * @description
 * Block selection dans les pages livraison et paiement
 * Ajout de la class active sur le label coché
 */
function selectionChange(block) {
  const inputs = block.querySelectorAll('input');
  inputs.forEach((input) => {
    if (input.checked) {
      input.parentNode.classList.add('active');
    } else {
      input.parentNode.classList.remove('active');
    }
  });
}

export default () => {
  const blocks = document.querySelectorAll('.selection-blocks');
  blocks.forEach((block) => {
    selectionChange(block);
    block.addEventListener('click', () => {
      selectionChange(block);
    });
  });
};
