<?php

declare(strict_types=1);

namespace Dedi\SyliusTheme\Resolver;

use App\Catalog\Repository\Product\ProductVariantRepositoryInterface;
use Sylius\Component\Product\Model\ProductInterface;
use Sylius\Component\Product\Model\ProductVariantInterface;
use Sylius\Component\Product\Resolver\ProductVariantResolverInterface as BaseProductVariantResolverInterface;

class ProductVariantResolver implements ProductVariantResolverInterface
{
    private BaseProductVariantResolverInterface $baseResolver;

    private ProductVariantRepositoryInterface $repository;

    public function __construct(
        BaseProductVariantResolverInterface $baseResolver,
        ProductVariantRepositoryInterface $repository
    ) {
        $this->baseResolver = $baseResolver;
        $this->repository = $repository;
    }

    public function getVariant(ProductInterface $subject): ?ProductVariantInterface
    {
        return $this->baseResolver->getVariant($subject);
    }

    public function getVariantWithCode(ProductInterface $subject, string $code): ?ProductVariantInterface
    {
        return $this->repository->findOneByCodeAndProductCode($code, $subject->getCode());
    }
}
