const path = require('path');
const webpack = require('webpack');

module.exports = (Encore) => {
  Encore
    .setOutputPath('public/assets/dedi')
    .setPublicPath('/assets/dedi')
    .addEntry('app', `${__dirname}/assets`)
    .addAliases({
      vendor: path.resolve(__dirname, '/node_modules'),
    })
    .addPlugin(new webpack.ProvidePlugin({
      $: 'jquery',
      jQuery: 'jquery',
      popper: 'popper.js',
      bootstrap: 'bootstrap/dist/js/bootstrap.min',
    }))
    .autoProvidejQuery()
    .disableSingleRuntimeChunk()
    .cleanupOutputBeforeBuild()
    .enableSassLoader()
    .enableSourceMaps(!Encore.isProduction())
    .enableVersioning(Encore.isProduction());

  const config = Encore.getWebpackConfig();
  config.name = 'dedi-theme';

  return config;
};
