/*
 * This file is part of the Sylius package.
 *
 * (c) Paweł Jędrzejewski
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/* eslint-env browser */

const SyliusApiLogin = (el) => {
  const signInButton = el.querySelector('#sylius-api-login-submit');
  const { url } = signInButton.dataset;
  const emailField = el.querySelector('input[type="email"]');
  const passwordField = el.querySelector('input[type="password"]');
  const csrfTokenField = el.querySelector('input[type="hidden"]');
  const csrfTokenName = csrfTokenField.getAttribute('name');

  signInButton.addEventListener('click', (e) => {
    e.preventDefault();

    const params = new FormData();
    params.append('_username', emailField.value);
    params.append('_password', passwordField.value);
    params.append([csrfTokenName], csrfTokenField.value);

    fetch(url, { method: 'POST', body: params })
      .then(() => { window.location.reload(); });
  });
};

export default SyliusApiLogin;
