# Sylius Dedi theme

Thème par défaut de Dedi pour Sylius

## Installation

Ajouter le dépôt dans `composer.json`.

```json
{
  ...
    "repositories": [
        {
            "type": "vcs",
            "url": "git@gitlab.com:dedi-agency/sylius-theme.git"
        }
    ],
  ...,
}
```

Puis ajouter la dépendance.

```shell script
$ composer require dedi/theme:@dev --prefer-source
```

## Configuration

Importer la configuration webpack du thème sur le fichier principale du projet.

```javascript
// ./webpack.config.js

const Encore = require('@symfony/webpack-encore');

// ...

Encore.reset();

const dediTheme = require('./vendor/dedi/theme/webpack.config')(Encore);
module.exports = [..., dediTheme];
```

Attention `dedi/theme` n'importe ni jQuery ni Popper.js ni Bootstrap.js, c'est à la charge du projet de le faire, exemple :

```javascript
// ./webpack.config.js

// ...

const webpack = require('webpack');

Encore
  // ...
  .addAliases({
    vendor: path.resolve(__dirname, 'vendor/dedi/theme/node_modules'),
  })
  .addPlugin(new webpack.ProvidePlugin({
    $: 'jquery',
    jQuery: 'jquery',
    popper: 'popper.js',
    bootstrap: 'bootstrap/dist/js/bootstrap.min',
  }));
```

Puis configurer en ajoutant dans `config/packages/assets.yaml` et `config/packages/webpack_encore.yaml`.

```yaml
# ./config/packages/assets.yaml

framework:
    assets:
        packages:
            ...
            dedi:
                json_manifest_path: '%kernel.project_dir%/public/build/dedi/manifest.json'
```

```yaml
# ./config/packages/webpack_encore.yaml

webpack_encore:
    output_path: ...
    builds:
        ...
        dedi: '%kernel.project_dir%/public/build/dedi'
```

Ajouter le thème dans sylius en éditant la configuration `config/_sylius.yaml`.

```yaml
# ./config/_sylius.yaml

sylius_theme:
    sources:
        filesystem:
            directories:
                - "%kernel.project_dir%/themes"
                - "%kernel.project_dir%/vendor/dedi/src/Resources/views/theme"
```

## Développement

Cloner le dépôt :

```bash
$ git clone git@gitlab.com:dedi-agency/sylius-theme.git dedi-theme
```

## Quickstart Installation

Pour faire fonctionner sans projet Sylius à coté :

```bash
$ make start
$ make db-create
$ make db-update
$ make fixtures
$ make build
```

Sinon :

Modifier composer.json du projet Sylius pour ajouter le repository local :

```json
{
  ...
    "repositories": [
        {
            "type": "path",
            "url": "/path/to/dedi-theme",
            "options": {
                "symlink": true
            }
        }
    ],
  ...,
}
```

Enfin créer le lien symbolique avec composer.

```
$ composer require dedi/theme:dev-master
```

Une autre solution est de clone le projet dans votre project Sylius.

Puis modifiez le composer.json du projet Sylius pour ajouter le repository local :

```json
{
  ...
    "repositories": [
        {
            "type": "vcs",
            "url": "https://gitlab.com/dedi-agency/interne/sylius/dedi-theme.git"
        },
    ],
  ...,
}
```

Puis faire

```
$ composer require dedi/theme:dev-master --prefer-source
```

## Ajouter une liste d'icônes pour le bloc UiElement "Icône et texte"

Créer une classe implémentant `Dedi\SyliusTheme\Utils\Icon\IconListInterface`.

Déclarer le service avec le tag `dedi_sylius_theme.icon_list`.

## Test

Test de code style.

```shell script
$ npm run test:cs
```

## Intégration

Modifier les fichiers scss/js dans le dossier dedi-theme puis copier les modifications dans les vendors du projet sylius
```
$ cp -R ~/PhpstormProjects/dedi-theme/* ~/PhpstormProjects/sylius/vendor/dedi/sylius-theme
```
