const path = require('path');
const webpack = require('webpack');

module.exports = (Encore) => {
  Encore
    .setOutputPath('public/build/dedi')
    .setPublicPath('/build/dedi')
    .addEntry('dedi', `${__dirname}/assets`)
    .addAliases({
      vendor: path.resolve(__dirname, '/node_modules'),
    })
    .addPlugin(new webpack.ProvidePlugin({
      $: 'jquery',
      jQuery: 'jquery',
      popper: 'popper.js',
      bootstrap: 'bootstrap/dist/js/bootstrap.min',
    }))
    .copyFiles({
      from: `${__dirname}/assets/media`,
      to: 'images/[path][name].[ext]',
    })
    .copyFiles({
      from: `${__dirname}/assets/fonts`,
      to: 'fonts/[path][name].[ext]',
    })
    .autoProvidejQuery()
    .disableSingleRuntimeChunk()
    .cleanupOutputBeforeBuild()
    .enableSassLoader()
    .enableSourceMaps(!Encore.isProduction())
    .enableVersioning(Encore.isProduction());

  const config = Encore.getWebpackConfig();
  config.name = 'dedi';

  return config;
};
