<?php

declare(strict_types=1);

namespace Dedi\SyliusTheme\Event;

use Sylius\Bundle\ResourceBundle\Event\ResourceControllerEvent;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\RequestStack;

class PostRegisterRedirectToCartListener
{
    private readonly RequestStack $requestStack;

    public function __construct(RequestStack $requestStack)
    {
        $this->requestStack = $requestStack;
    }

    public function __invoke(ResourceControllerEvent $event)
    {
        $redirectTo = $this->requestStack->getMasterRequest()->get('redirect');

        if (null !== $redirectTo) {
            $event->setResponse(new RedirectResponse($redirectTo));
        }
    }
}
