<?php

declare(strict_types=1);

namespace Dedi\SyliusTheme\Controller\Styleguide;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\TextType;

class StyleguideController extends AbstractController
{
    public function template(string $templateName)
    {
        return $this->render("@DediSyliusTheme/Styleguide/$templateName.html.twig");
    }

    public function styleguide()
    {
        $form = $this->createFormBuilder(null, [
            'attr' => [
                'novalidate' => true,
            ],
        ])
            ->add('txtName01', TextType::class, [
                'label' => 'Exemple de champ text obligatoire',
                'required' => true,
            ])
            ->add('txtName02', TextType::class, [
                'label' => 'Exemple de champ text',
                'required' => false,
                'data' => 'Exemple de champ rempli',
                'attr' => [
                    'placeholder' => 'Exemple de placeholder',
                ],
            ])
            ->add('txtName03', TextType::class, [
                'label' => 'Exemple de champ text',
                'required' => false,
                'help' => "Exemple de texte d'aide ou d'information",
                'attr' => [
                    'placeholder' => 'Exemple de placeholder',
                ],
            ])
            ->add('txtName04', TextType::class, [
                'disabled' => true,
                'required' => false,
                'label' => 'Exemple de champ text disabled',
            ])

            ->add('selectName01', ChoiceType::class, [
                'placeholder' => 'Sélectionnez un élément',
                'label' => 'Exemple de champ select',
                'choices' => [
                    'Item 1' => '1',
                    'Item 2' => '2',
                    'Item 3' => '3',
                    'Item 4' => '4',
                    'Item 5' => '5',
                ],
                'invalid_message' => 'Message d\'erreur',
            ])
            ->add('selectName02', ChoiceType::class, [
                'placeholder' => 'Sélectionnez un élément',
                'label' => 'Exemple de champ select disabled',
                'required' => false,
                'disabled' => true,
                'choices' => [
                    'Item 1' => '1',
                    'Item 2' => '2',
                    'Item 3' => '3',
                    'Item 4' => '4',
                    'Item 5' => '5',
                ],
                'invalid_message' => 'Message d\'erreur',
            ])

            ->add('customCheckbox01', ChoiceType::class, [
                'expanded' => true,
                'multiple' => true,
                'label' => 'Exemple de checkbox',
                'choices' => [
                    'Checkbox 01' => '1',
                    'Checkbox 02' => '2',
                ],
                'data' => [
                    'Checkbox 01' => '1',
                ],
                'required' => true,
            ])
            ->add('customCheckbox02', ChoiceType::class, [
                'expanded' => true,
                'multiple' => true,
                'label' => 'Exemple de checkbox disabled',
                'choices' => [
                    'Checkbox disabled 01' => '1',
                    'Checkbox disabled 02' => '2',
                ],
                'data' => [
                    'Checkbox 01' => '1',
                ],
                'required' => false,
                'disabled' => true,
            ])

            ->add('customRadio01', ChoiceType::class, [
                'expanded' => true,
                'multiple' => false,
                'label' => 'Exemple de radio disabled',
                'choices' => [
                    'Radio 01' => '1',
                    'Radio 02' => '2',
                ],
                'data' => '1',
            ])
            ->add('customRadio02', ChoiceType::class, [
                'expanded' => true,
                'multiple' => false,
                'label' => 'Exemple de radio disabled',
                'choices' => [
                    'Radio disabled 01' => '1',
                    'Radio disabled 02' => '2',
                ],
                'data' => '1',
                'required' => false,
                'disabled' => true,
                'placeholder' => false,
            ])

            ->add('customSwitch01', ChoiceType::class, [
                'expanded' => true,
                'multiple' => true,
                'label' => 'Exemple de switch disabled',
                'choices' => [
                    'Switch 01' => '1',
                    'Switch 02' => '2',
                ],
                'data' => [
                    'Switch 01' => '1',
                ],
                'label_attr' => ['class' => 'custom-switch'],
            ])
            ->add('customSwitch02', ChoiceType::class, [
                'expanded' => true,
                'multiple' => true,
                'label' => 'Exemple de switch disabled',
                'choices' => [
                    'Switch disabled 01' => '1',
                    'Switch disabled 02' => '2',
                ],
                'data' => [
                    'Switch 01' => '1',
                ],
                'label_attr' => ['class' => 'custom-switch'],
                'required' => false,
                'disabled' => true,
            ])

            ->add('txtareaName01', TextareaType::class, [
                'label' => 'Exemple de champ textarea',
                'invalid_message' => 'Message d\'erreur',
                'attr' => [
                    'rows' => 4,
                ],
            ])
            ->add('txtareaName02', TextareaType::class, [
                'label' => 'Exemple de champ textarea disabled',
                'invalid_message' => 'Message d\'erreur',
                'attr' => [
                    'rows' => 4,
                ],
                'required' => false,
                'disabled' => true,
            ])

            ->getForm()
        ;

        return $this->render('@DediSyliusTheme/Styleguide/styleguide.html.twig', ['form' => $form->createView()]);
    }

    public function designSystemTemplate(string $templateName)
    {
        $form = $this->createFormBuilder(null, [
            'attr' => [
                'novalidate' => true,
            ],
        ])
            ->add('txtName01', TextType::class, [
                'label' => 'app.design_system.forms.input.text_required',
                'required' => true,
            ])
            ->add('txtName02', TextType::class, [
                'label' => 'app.design_system.forms.input.text_filled',
                'required' => false,
                'data' => 'Lorem ipsum',
                'attr' => [
                    'placeholder' => 'app.design_system.forms.input.placeholder',
                ],
            ])
            ->add('txtName03', TextType::class, [
                'label' => 'app.design_system.forms.input.text',
                'required' => false,
                'help' => 'app.design_system.forms.input.help',
                'attr' => [
                    'placeholder' => 'app.design_system.forms.input.placeholder',
                ],
            ])
            ->add('txtName04', TextType::class, [
                'disabled' => true,
                'required' => false,
                'label' => 'app.design_system.forms.input.text_disabled',
                'attr' => [
                    'placeholder' => 'app.design_system.forms.input.placeholder',
                ],
            ])

            ->add('selectName01', ChoiceType::class, [
                'placeholder' => 'app.design_system.forms.select.select_item',
                'label' => 'app.design_system.forms.select.example',
                'choices' => [
                    'Item 1' => '1',
                    'Item 2' => '2',
                    'Item 3' => '3',
                    'Item 4' => '4',
                    'Item 5' => '5',
                ],
                'invalid_message' => 'app.design_system.forms.select.error_text',
            ])
            ->add('selectName02', ChoiceType::class, [
                'placeholder' => 'app.design_system.forms.select.select_item',
                'label' => 'app.design_system.forms.select.select_disabled',
                'required' => false,
                'disabled' => true,
                'choices' => [
                    'Item 1' => '1',
                    'Item 2' => '2',
                    'Item 3' => '3',
                    'Item 4' => '4',
                    'Item 5' => '5',
                ],
                'invalid_message' => 'app.design_system.forms.select.error_text',
            ])

            ->add('customCheckbox01', ChoiceType::class, [
                'expanded' => true,
                'multiple' => true,
                'label' => 'app.design_system.forms.checkbox.checkbox',
                'choices' => [
                    'Checkbox 01' => '1',
                    'Checkbox 02' => '2',
                ],
                'data' => [
                    'Checkbox 01' => '1',
                ],
                'required' => true,
            ])
            ->add('customCheckbox02', ChoiceType::class, [
                'expanded' => true,
                'multiple' => true,
                'label' => 'app.design_system.forms.checkbox.checkbox_disabled',
                'choices' => [
                    'Checkbox disabled 01' => '1',
                    'Checkbox disabled 02' => '2',
                ],
                'data' => [
                    'Checkbox 01' => '1',
                ],
                'required' => false,
                'disabled' => true,
            ])

            ->add('customRadio01', ChoiceType::class, [
                'expanded' => true,
                'multiple' => false,
                'label' => 'app.design_system.forms.checkbox.radio',
                'choices' => [
                    'Radio 01' => '1',
                    'Radio 02' => '2',
                ],
                'data' => '1',
            ])
            ->add('customRadio02', ChoiceType::class, [
                'expanded' => true,
                'multiple' => false,
                'label' => 'app.design_system.forms.checkbox.radio_disabled',
                'choices' => [
                    'Radio disabled 01' => '1',
                    'Radio disabled 02' => '2',
                ],
                'data' => '1',
                'required' => false,
                'disabled' => true,
                'placeholder' => false,
            ])

            ->add('customSwitch01', ChoiceType::class, [
                'expanded' => true,
                'multiple' => true,
                'label' => 'app.design_system.forms.checkbox.switch',
                'choices' => [
                    'Switch 01' => '1',
                    'Switch 02' => '2',
                ],
                'data' => [
                    'Switch 01' => '1',
                ],
                'label_attr' => ['class' => 'custom-switch'],
            ])
            ->add('customSwitch02', ChoiceType::class, [
                'expanded' => true,
                'multiple' => true,
                'label' => 'app.design_system.forms.checkbox.switch_disabled',
                'choices' => [
                    'Switch disabled 01' => '1',
                    'Switch disabled 02' => '2',
                ],
                'data' => [
                    'Switch 01' => '1',
                ],
                'label_attr' => ['class' => 'custom-switch'],
                'required' => false,
                'disabled' => true,
            ])

            ->add('txtareaName01', TextareaType::class, [
                'label' => 'app.design_system.forms.textarea.example',
                'invalid_message' => 'app.design_system.forms.textarea.error_text',
                'attr' => [
                    'rows' => 4,
                ],
            ])
            ->add('txtareaName02', TextareaType::class, [
                'label' => 'app.design_system.forms.textarea.example_disabled',
                'invalid_message' => 'app.design_system.forms.textarea.error_text',
                'attr' => [
                    'rows' => 4,
                ],
                'required' => false,
                'disabled' => true,
            ])

            ->add('dateName01', DateType::class, [
                'label' => 'app.design_system.forms.date.example',
                'required' => true,
                'widget' => 'single_text',
                'attr' => [
                    'placeholder' => 'app.design_system.forms.input.placeholder',
                ],
            ])
            ->add('dateName02', DateType::class, [
                'label' => 'app.design_system.forms.input.text_disabled',
                'disabled' => true,
                'required' => false,
                'widget' => 'single_text',
            ])

            ->getForm()
        ;

        return $this->render("@DediSyliusTheme/DesignSystem/$templateName.html.twig", ['form' => $form->createView()]);
    }

    public function designSystem()
    {
        return $this->render('@DediSyliusTheme/DesignSystem/index.html.twig');
    }
}
