<?php

declare(strict_types=1);

namespace Dedi\SyliusTheme\Form\Type;

use Dedi\SyliusTheme\Utils\Icon\IconListInterface;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormBuilderInterface;

class IconType extends AbstractType
{
    private IconListInterface $iconList;

    public function __construct(IconListInterface $iconList)
    {
        $this->iconList = $iconList;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('icon', ChoiceType::class, [
                'choices' => $this->iconList->getList(),
            ])
        ;
    }
}
