/**
 * @description Gestion des formulaires
 * - Bootstrap select
 * - Champs actifs
 */

/**
 * @description Activation des input si une valeur est renseignée
 */
function inputActive(el) {
  if (el.value) {
    el.classList.add('active');
  } else {
    el.classList.remove('active');
  }
}

export default () => {
  /**
     * @description Activation des input text et textarea lorsqu'ils sont remplis
     */
  const els = document.querySelectorAll('.form-control');
  Array.from(els)
    .forEach((el) => {
      inputActive(el);

      el.addEventListener('blur', () => {
        inputActive(el);
      });
    });

  /**
     * @description Boostrap Select
     * Hack boostrap 4
     * Activation du champ lorsqu'une valeur est sélectionnée
     */
  $.fn.selectpicker.Constructor.BootstrapVersion = '4';
  $('.selectpicker').on('changed.bs.select', (e, clickedIndex, isSelected) => {
    const dropDown = e.target.nextSibling;
    if (isSelected && e.target.value) {
      dropDown.classList.add('active');
    } else {
      dropDown.classList.remove('active');
    }
  });
};
