<?php

declare(strict_types=1);

namespace Dedi\SyliusTheme\Specification;

use Sylius\Component\Core\Model\ProductVariantInterface;

class IsVariantStockAvailableSpecification
{
    public static function isSatisfiedBy(ProductVariantInterface $variant): bool
    {
        return !$variant->isTracked() || 0 < ($variant->getOnHand() - $variant->getOnHold());
    }
}
