/**
 * @description Gestion des carousels
 */

/**
 * @description slider par défaut
 */
function sliderDefault() {
  if (document.querySelector('.default-slider')) {
    $('.default-slider').slick({
      slidesToShow: 1,
      slidesToScroll: 1,
      dots: true,
      arrows: true,
    });
  }
}

/**
 * @description Carousel image produit avec carousel sur les thumbnails
 * Suppression des lightbox sur les éléments clonés
 */
function sliderProduct() {
  if (document.querySelector('.product-show-images-slider')) {
    $('.product-show-images-slider').on('init', () => {
      const clonedItems = document.querySelectorAll('.product-show-images-slider .slick-cloned');
      Array.from(clonedItems)
        .forEach((clonedItem) => {
          // eslint-disable-next-line no-param-reassign
          clonedItem.innerHTML = clonedItem.querySelector('a').innerHTML;
        });
    }).slick({
      slidesToShow: 1,
      slidesToScroll: 1,
      arrows: false,
      dots: true,
      mobileFirst: true,
      responsive: [
        {
          breakpoint: 767,
          settings: {
            dots: false,
            asNavFor: '.product-show-images-thumbnail',
          },
        },
      ],
    });
  }

  if (document.querySelector('.product-show-images-thumbnail')) {
    $('.product-show-images-thumbnail').slick({
      slidesToShow: 4,
      slidesToScroll: 1,
      asNavFor: '.product-show-images-slider',
      dots: false,
      arrows: false,
      focusOnSelect: true,
      mobileFirst: true,
      responsive: [
        {
          breakpoint: 1199,
          settings: {
            slidesToShow: 5,
          },
        },
      ],
    });
  }
}

export default () => {
  sliderDefault();
  sliderProduct();
};
