function colorsCode() {
  const colors = document.querySelectorAll('.ds-color');
  const rgba2hex = (rgba) => `#${rgba.match(/^rgba?\((\d+),\s*(\d+),\s*(\d+)(?:,\s*(\d+\.{0,1}\d*))?\)$/).slice(1).map((n, i) => (i === 3 ? Math.round(parseFloat(n) * 255) : parseFloat(n)).toString(16).padStart(2, '0').replace('NaN', '')).join('')}`

  colors.forEach((color) => {
    const codeHex = rgba2hex(window.getComputedStyle(color).backgroundColor).toUpperCase();
    const codeSpan = document.createElement('span');
    codeSpan.classList.add('code');
    codeSpan.append(codeHex);

    color.append(codeSpan);
  });
}

export default colorsCode;
