<?php

declare(strict_types=1);

namespace Dedi\SyliusTheme\Twig;

use Dedi\SyliusTheme\Specification\IsRequestFrontOfficeSpecification;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\RequestStack;
use Twig\Extension\AbstractExtension;
use Twig\Extension\GlobalsInterface;

class IsFrontOfficeExtension extends AbstractExtension implements GlobalsInterface
{
    private readonly ?Request $masterRequest;

    private readonly IsRequestFrontOfficeSpecification $isRequestFrontOfficeSpecification;

    public function __construct(
        RequestStack $requestStack,
        IsRequestFrontOfficeSpecification $isRequestFrontOfficeSpecification
    ) {
        $this->masterRequest = $requestStack->getMasterRequest();
        $this->isRequestFrontOfficeSpecification = $isRequestFrontOfficeSpecification;
    }

    public function getGlobals()
    {
        return [
            'isFrontOffice' => $this->isRequestFrontOfficeSpecification->__invoke($this->masterRequest),
        ];
    }
}
