module.exports = (Encore) => {
    Encore
        .setOutputPath('public/assets/dedi')
        .setPublicPath('/assets/dedi')
        .addEntry('app', __dirname + '/assets')
        .disableSingleRuntimeChunk()
        .cleanupOutputBeforeBuild()
        .enableSassLoader()
        .enableSourceMaps(!Encore.isProduction())
        .enableVersioning(Encore.isProduction());

    const config = Encore.getWebpackConfig();
    config.name = 'dedi-theme';

    return config;
};
