# Sylius Dedi theme

Thème par défaut de Dedi pour Sylius

## Installation

Ajouter le dépôt dans `composer.json`.

```json
{
  ...
    "repositories": [
        {
            "type": "vcs",
            "url": "git@gitlab.com:dedi-agency/sylius-theme.git"
        }
    ],
  ...,
}
```

Puis ajouter la dépendance.

```shell script
$ composer require dedi/theme:@dev --prefer-source
```

## Configuration

Importer la configuration webpack du thème sur le fichier principale du projet.

```javascript
// ./webpack.config.js

const Encore = require('@symfony/webpack-encore');

// ...

Encore.reset();

const dediTheme = require('./vendor/dedi/theme/webpack.config')(Encore);
module.exports = [..., dediTheme];
```

Configurer en ajoutant dans `config/packages/assets.yaml` et `config/packages/webpack_encore.yaml`.

```yaml
# ./config/packages/assets.yaml

framework:
    assets:
        packages:
            ...
            dedi:
                json_manifest_path: '%kernel.project_dir%/public/assets/dedi/manifest.json'
```

```yaml
# ./config/packages/webpack_encore.yaml

webpack_encore:
    output_path: ...
    builds:
        ...
        dedi: '%kernel.project_dir%/public/assets/dedi'
```

Ajouter le thème dans sylius en éditant la configuration `config/_sylius.yaml`.

```yaml
# ./config/_sylius.yaml

sylius_theme:
    sources:
        filesystem:
            directories:
                - "%kernel.project_dir%/themes"
                - "%kernel.project_dir%/vendor/dedi/theme"
```

## Développement

Cloner le dépôt :

```bash
$ git clone git@gitlab.com:dedi-agency/sylius-theme.git dedi-theme
```

Puis modifier composer.json du projet Sylius pour ajouter le repository local :

```json
{
  ...
    "repositories": [
        {
            "type": "path",
            "url": "/path/to/dedi-theme",
            "options": {
                "symlink": true
            }
        }
    ],
  ...,
}
```

Enfin créer le lien symbolique avec composer.

```
$ composer require dedi/theme:dev-master
```

## Test

Test de code style.

```shell script
$ npm run test:cs
```
