<?php

declare(strict_types=1);

namespace Tests\Dedi\SyliusTaxonTypePlugin\Application\src\Entity;

use Dedi\SyliusTaxonTypePlugin\Model\BrandAwareInterface;
use Dedi\SyliusTaxonTypePlugin\Model\BrandAwareTrait;
use Dedi\SyliusTaxonTypePlugin\Model\SelectionAwareInterface;
use Dedi\SyliusTaxonTypePlugin\Model\SelectionAwareTrait;
use Doctrine\ORM\Mapping as ORM;
use Sylius\Component\Core\Model\Product as BaseProduct;

/**
 * @ORM\Entity
 * @ORM\Table(name="sylius_product")
 */
class Product extends BaseProduct implements BrandAwareInterface, SelectionAwareInterface
{
    use BrandAwareTrait;

    use SelectionAwareTrait {
        SelectionAwareTrait::__construct as private __selectionAwareConstruct;
    }

    public function __construct()
    {
        parent::__construct();

        $this->__selectionAwareConstruct();
    }
}
