<?php

declare(strict_types=1);

namespace Dedi\SyliusTaxonTypePlugin\Model;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Sylius\Component\Core\Model\ProductTaxonInterface;

trait SelectionAwareTrait
{
    private Collection $selections;

    public function __construct()
    {
        $this->selections = new ArrayCollection();
    }

    /** Collection|ProductTaxonInterface[] */
    public function getProductSelectionTaxons(): Collection
    {
        return $this->productTaxons->filter(fn (ProductTaxonInterface $productTaxon) => $productTaxon->getTaxon()->getType() === TypedTaxonInterface::SELECTION_TYPE);
    }

    public function getSelections(): Collection
    {
        return $this->selections;
    }

    public function setSelections(Collection $selections): void
    {
        $this->selections = $selections;
    }
}
