<?php

declare(strict_types=1);

namespace Dedi\SyliusTaxonTypePlugin\Model;

use Doctrine\Common\Collections\Collection;

interface ProductBrandAwareInterface
{
    public function hasBrandProducts(): bool;

    public function getBrandProducts(): Collection;

    public function hasBrandProduct(BrandAwareInterface $product): bool;

    public function addBrandProduct(BrandAwareInterface $product): void;

    public function removeBrandProduct(BrandAwareInterface $product): void;
}
