<?php

declare(strict_types=1);

namespace Dedi\SyliusTaxonTypePlugin\Menu;

use Dedi\Contracts\SyliusPluginSettings\SettingsProviderInterface;
use Sylius\Bundle\AdminBundle\Event\ProductMenuBuilderEvent;

final class AdminBrandProductFormMenuListener
{
    public function __construct(
        private readonly SettingsProviderInterface $settingsProvider,
    ) {
    }

    public function addItems(ProductMenuBuilderEvent $event): void
    {
        if (!$this->settingsProvider->provide()->isEnabled()) {
            return;
        }

        $menu = $event->getMenu();

        $menu
            ->addChild('brand')
            ->setAttribute('template', '@DediSyliusTaxonTypePlugin/Admin/Product/_brand.html.twig')
            ->setLabel('dedi_sylius_taxon_type_plugin.ui.brand')
        ;
    }
}
