<?php

declare(strict_types=1);

namespace Dedi\SyliusTaxonTypePlugin\Menu;

use Dedi\Contracts\SyliusPluginSettings\SettingsProviderInterface;
use Knp\Menu\ItemInterface;
use Sylius\Bundle\UiBundle\Menu\Event\MenuBuilderEvent;

final class AdminBrandMenuListener
{
    public function __construct(
        private readonly SettingsProviderInterface $settingsProvider,
    ) {
    }

    public function addAdminMenuItems(MenuBuilderEvent $event): void
    {
        if (!$this->settingsProvider->provide()->isEnabled()) {
            return;
        }

        $menu = $event->getMenu();

        $catalog = $menu->getChild('catalog');

        if ($catalog instanceof ItemInterface) {
            $this->addChild($catalog);
        } else {
            $this->addChild($menu->getFirstChild());
        }
    }

    private function addChild(ItemInterface $item): void
    {
        $item
            ->addChild(
                'brands',
                [
                    'route' => 'sylius_admin_brand_taxon_index',
                ],
            )
            ->setLabel('dedi_sylius_taxon_type_plugin.ui.brands')
            ->setLabelAttribute('icon', 'building');
    }
}
