<?php

declare(strict_types=1);

namespace Dedi\SyliusTaxonTypePlugin\Grid\Filter;

use Dedi\SyliusTaxonTypePlugin\Model\TypedTaxonInterface;
use Sylius\Component\Grid\Data\DataSourceInterface;
use Sylius\Component\Grid\Filtering\FilterInterface;

class ProductBrandFilter implements FilterInterface
{
    public function apply(DataSourceInterface $dataSource, string $name, $data, array $options): void
    {
        if ('' === $data[TypedTaxonInterface::BRAND_TYPE]) {
            return;
        }

        $dataSource->restrict(
            $dataSource
                ->getExpressionBuilder()
                ->equals(
                    TypedTaxonInterface::BRAND_TYPE,
                    $data[TypedTaxonInterface::BRAND_TYPE],
                ),
        );
    }
}
