<?php

/*
 * This file is part of the Sylius package.
 *
 * (c) Paweł Jędrzejewski
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

declare(strict_types=1);

namespace Dedi\SyliusTaxonTypePlugin\Form\Type;

use Dedi\SyliusTaxonTypePlugin\Form\DataTransformer\ProductTaxonToProductTransformer;
use Sylius\Bundle\ResourceBundle\Form\DataTransformer\RecursiveTransformer;
use Sylius\Bundle\ResourceBundle\Form\Type\ResourceAutocompleteChoiceType;
use Sylius\Component\Core\Model\TaxonInterface;
use Sylius\Component\Resource\Factory\FactoryInterface;
use Sylius\Component\Resource\Repository\RepositoryInterface;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormView;
use Symfony\Component\OptionsResolver\OptionsResolver;

final class TaxonProductAutocompleteChoiceType extends AbstractType
{
    private readonly FactoryInterface $productTaxonFactory;

    private readonly RepositoryInterface $productTaxonRepository;

    public function __construct(FactoryInterface $productTaxonFactory, RepositoryInterface $productTaxonRepository)
    {
        $this->productTaxonFactory = $productTaxonFactory;
        $this->productTaxonRepository = $productTaxonRepository;
    }

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        if (true === $options['multiple']) {
            $builder->addModelTransformer(
                new RecursiveTransformer(
                    new ProductTaxonToProductTransformer(
                        $this->productTaxonFactory,
                        $this->productTaxonRepository,
                        $options['taxon'],
                    ),
                ),
            );
        } else {
            $builder->addModelTransformer(
                new ProductTaxonToProductTransformer(
                    $this->productTaxonFactory,
                    $this->productTaxonRepository,
                    $options['taxon'],
                ),
            );
        }
    }

    public function buildView(FormView $view, FormInterface $form, array $options): void
    {
        $view->vars['remote_criteria_type'] = 'contains';
        $view->vars['remote_criteria_name'] = 'phrase';
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            'resource' => 'sylius.product',
            'choice_name' => 'name',
            'choice_value' => 'code',
        ]);

        $resolver
            ->setRequired('taxon')
            ->setAllowedTypes('taxon', TaxonInterface::class)
        ;
    }

    public function getParent(): string
    {
        return ResourceAutocompleteChoiceType::class;
    }

    public function getBlockPrefix(): string
    {
        return 'sylius_taxon_product_autocomplete_choice';
    }
}
