<?php

declare(strict_types=1);

namespace Dedi\SyliusTaxonTypePlugin\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

final class Configuration implements ConfigurationInterface
{
    /**
     * @psalm-suppress UnusedVariable
     */
    public function getConfigTreeBuilder(): TreeBuilder
    {
        $treeBuilder = new TreeBuilder('dedi_sylius_taxon_type_plugin');
        $rootNode = $treeBuilder->getRootNode();

        $rootNode
            ->children()
            ->scalarNode('enabled')
            ->defaultValue(true)
            ->info('Enable taxonType usage in Sylius')
            ->example('true')
            ->end()
        ;

        return $treeBuilder;
    }
}
