<?php

declare(strict_types=1);

namespace Tests\Dedi\SyliusTaxonTypePlugin\Application\src\Entity;

use Dedi\SyliusTaxonTypePlugin\Model\ProductBrandAwareInterface;
use Dedi\SyliusTaxonTypePlugin\Model\ProductBrandAwareTrait;
use Dedi\SyliusTaxonTypePlugin\Model\ProductTaxonAwareInterface;
use Dedi\SyliusTaxonTypePlugin\Model\ProductTaxonAwareTrait;
use Dedi\SyliusTaxonTypePlugin\Model\TypedTaxonInterface;
use Dedi\SyliusTaxonTypePlugin\Model\TypedTaxonTrait;
use Doctrine\ORM\Mapping as ORM;
use Sylius\Component\Core\Model\Taxon as BaseTaxon;

/**
 * @ORM\Entity
 * @ORM\Table(name="sylius_taxon")
 */
class Taxon extends BaseTaxon implements TypedTaxonInterface, ProductBrandAwareInterface, ProductTaxonAwareInterface
{
    use TypedTaxonTrait;

    use ProductTaxonAwareTrait {
        ProductTaxonAwareTrait::__construct as private __productTaxonAwareTraitConstruct;
    }

    use ProductBrandAwareTrait {
        ProductBrandAwareTrait::__construct as private __productAwareTraitConstruct;
    }

    public function __construct()
    {
        parent::__construct();

        $this->__productAwareTraitConstruct();
        $this->__productTaxonAwareTraitConstruct();
    }
}