<?php

declare(strict_types=1);

namespace Dedi\SyliusTaxonTypePlugin\Request;

use Sylius\Bundle\ResourceBundle\Controller\RequestConfiguration;
use Sylius\Bundle\ResourceBundle\Controller\RequestConfigurationFactoryInterface;
use Sylius\Resource\Metadata\MetadataInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\RequestStack;

final class RequestConfigurationFactory implements RequestConfigurationFactoryInterface
{
    public function __construct(
        private readonly RequestConfigurationFactoryInterface $decoratedFactory,
        private readonly RequestStack $requestStack,
    ) {
    }

    public function create(MetadataInterface $metadata, Request $request): RequestConfiguration
    {
        $parameters = $request->attributes->get('_sylius', []);

        if (null === $this->requestStack->getParentRequest() &&
            array_key_exists('vars', $parameters) &&
            array_key_exists('factory', $parameters['vars'])
        ) {
            $parameters['factory'] = $parameters['vars']['factory'];
            $request->attributes->set('_sylius', $parameters);
        }

        return $this->decoratedFactory->create($metadata, $request);
    }
}
