<?php

declare(strict_types=1);

namespace Dedi\SyliusTaxonTypePlugin\Repository;

trait ProductAutocompleteRepositoryTrait
{
    public function findByPhrase(string $phrase, string $locale, ?int $limit = null): iterable
    {
        return $this->createQueryBuilder('t')
            ->innerJoin('t.translations', 'translation', 'WITH', 'translation.locale = :locale')
            ->andWhere('translation.name LIKE :phrase OR t.code LIKE :phrase')
            ->setParameter('phrase', '%' . $phrase . '%')
            ->setParameter('locale', $locale)
            ->setMaxResults($limit)
            ->getQuery()
            ->getResult()
        ;
    }
}
